Subject: Manual for ircII
 
/************************************************************************
 *   IRC - Internet Relay Chat, doc/MANUAL
 *   Copyright (C) 1990, Karl Kleinpaste
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

						Date: 04 Apr 1989
					      Author: Karl Kleinpaste
						      karl@cis.ohio-state.edu
						
				   Last modification: 15 May 1992
						  by  Mauri Haikola 
						      mjh@stekt.oulu.fi


			 INTERNET RELAY CHAT
		  a real-time conversational system


* 1: Irc - replacement for talk(1)

Irc is a functional replacement for and improvement to talk(1).  Talk
is an old, primitive, atrocious, minimalist sort of keyboard/screen
conversation tool, using a grotesque, machine-dependent protocol.
Irc does everything talk does, but with a better protocol, allowing
more than 2 users to talk at once, with access across the aggregate
Internet, and providing a whole raft of other useful features.

* 2: Entering Internet Relay Chat

There are two ways to enter Internet Relay Chat. If you are using the
emacs lisp client, you need to load the client into your Emacs session
and then M-x irc. If you are using the C client (easier for beginners)
then type (usually) irc. If you wish to be known by a nickname which
is not one's login name, type `irc chosen-nickname' instead.

* 3: How much can be seen from here

The universe - seriously.

This is most formally called Internet Relay Chat.  Server hosts are
connected via a tree structure.  The various servers relay control and
message data among themselves to advertise the existence of other
servers, users, and the channels and other resources being occupied by
those users.

* 4: Structure

There is quite a lot of structure to the operation of irc, as
compared to crufty old talk(1).  Since so little could be done with
talk(1), it needed little structure.  But to keep track of people
spread literally around the world (the system was written by Jarkko
Oikarinen of Finland, usually seen on the system as `Wiz'), the
structure is useful so that one can speak to exactly those people with
whom one wishes to speak.

** 4.1: Nicknames

All users of irc are known to the system by a `nickname.'  By
default, one's nickname is one's login name.  Nickname clashes are not
allowed; this is enforced by the servers.  If one's intended nickname
clashes with someone else as one enters chat, one will not be able to
complete entry to irc until one changes one's nickname to something
else.

** 4.2: Presence on a channel

Fundamental to the operation of irc is the concept of a channel.  All
users are `on a channel' while inside irc.  One enters the `null
channel' first.  One cannot send any messages while not in any
chatting channel unless one has set up a private conversation in some
way.  The number of channels is essentially unlimited - whatever will
fit in a string of some ungodly length, that must start with a # sign.

** 4.3: Main modes of channels

Public

This is the default mode for a channel. When one is on a public
channel, one can be seen by all other users (if one's own user mode
permits this).  Anyone can notice users on a public channel and join
such a channel's conversation.

Private

This means that, although anyone can see that one is using chat, no
one can tell what channel one is using unless one is already on that
channel with oneself.  Since the number of potential channels is in
the billions, this is quite some security - all one gives away is the
acknowledgement that one is using chat.

Secret

While one is on a secret channel, no one who is not on one's channel
with oneself can even see that one is there.  One's name does not show
up in a list of active users.  The only indication of one's presence
is that, when entering chat, all new users are told that there are "N
users on P servers."  If one checks on all users and finds less than N
of them, one knows that others are hiding on secret channels.  But a
secret channel user still cannot be found except by brute-force
checking through all channels, a hopeless proposition in the face of
the huge number of possible channel names. Security through obscurity
finally means something.

Changing the mode

The mode of a channel (private, secret, invite-only, moderated,
topic-limited, person-number-limited, no-messages-to-channel, ban
someone from channel) is set by the channel operator, who is the
first person to join a channel, or someone who has had channel
operatorship bestowed on them by another channel operator. 


*** 4.4: Conversations not using channels

It is possible to conduct conversations with others without using the
formalized channel structure.  Doing so requires that two people set
themselves up for private conversation using special commands; see
User Commands below.

* 5: Screen/keyboard structure

Chat is a full-screen utility.  It takes over the screen, with the
bulk of activity happening in the top N-2 lines, a modeline (vaguely
emacs-like) on the next to last line, and one's input being entered on
the last line.  A very good version of client is the IRC-II client,
avaliable on anonymous ftp from various sites around the world.

** 5.1: Keyboard input

When typing commands at irc, one has a minimalist line-editing
facility in an emacs style.  That is, ^A moves the cursor to the
beginning of the line, ^E goes to the end, ^D deletes the character
under the cursor, ^K kills from the cursor to the end, and so on.  

** 5.2: Screen activity

Almost everything happens in the upper bulk of the screen.  This
includes both messages from other users, as well as the output of the
control commands.

Normal messages from other users appear with the originating nickname
in <angle brackets>.  Private messages arrive with the originating
nickname in *asterisks*.  Messages which one sends to everyone appear
with a preceding "> " whereas messages which one sends privately to
one other user appear with "-> *nickname*."

Other output (e.g., /who commands, invitations from other users to
join channels, and so forth) appears interspersed with other activity
on the screen.

* 6: Command structure

Ordinary text typed at irc is sent as one's messages to everyone else
on the same channel, modulo personal choices for private messages and
the like.  Commands to irc itself all begin with a command character,
which is initially `/' but may be changed to any other character
desired.

Commands may in general be abbreviated to a unique prefix.

** 6.1: Leaving irc

The way to get out of irc is to enter the /signoff command.  "/si" is
sufficient.  Also equivalent are "/exit," "/bye," and "/quit." A
signoff command may include a comment which will be seen by everyone
on the current channel of the person who left.

** 6.2: Getting help

Type "/help."  Follow the instructions.

** 6.3: User commands

The most important commands supported by irc are:

      help   signoff       who     whois
      list     topic      join   channel
     links       msg    invite    ignore
     users     stats      nick      away
      info     clear     query     cmdch
      date      mode

*** 6.3.1: help

Information on how to use the rest of the system is available via
/help.  The modeline says so as well.

*** 6.3.2: signoff {comment}

/signoff exits chat. Optional comment may be included; see above.

*** 6.3.3: who

/who returns information on who is using chat.  /who without arguments
prints info on all users that can be seen.  Users of public channels
show up with their channel identified.  Users of private channels
appear, but they are specified as being on a private, unspecified
channel.  Users of secret channels and users whose user mode is +i
(invisible) do not appear at all.

Giving a channel name as an argument to /who returns only those users of the
specified channel.  This still doesn't show users of secret channel or
invisible users one is actually on the same channel with them. Users
of private channels are shown, if an exact channel name is given.

*** 6.3.4: whois

This returns information about individual users.  Say "/whois
nickname" to get information on the login name and host from which the
nicknamed user comes.

*** 6.3.5: topic

Channels can be given off-the-cuff "topics."  Saying "/topic some
string of text" will associate that topic with the current channel.

*** 6.3.6: list

/list will give lists of active channels, the number of users of each,
and the topics therewith associated.  Again, secret channels do not
appear and private channels only appear as Prv.

*** 6.3.7: join & channel

/join or /channel are the means to enter a channel.  Give the channel
name as an argument.  If this is a secret or hidden channel, /who
commands will show oneself and any other users of one's channel.

One's arrival on a channel is announced to the rest of the users
already on that channel.  Silent, anonymous "lurking" is not
supported.

*** 6.3.8: links

/links lists the currently-active set of chat servers.  Beware: this
list can be quite long, and will undoubtedly get longer as chat gains
wider use.  As of 15 May, 1992, about 130 servers is typical.

*** 6.3.9: msg

A single message can be sent privately to a certain user with /msg.
Type /msg nickname and the text to be sent.  It will be sent privately
to the indicated nickname.

*** 6.3.10: invite

If there is a user online to whom one wishes to speak, one may invite
that user to join oneself on a certain channel.  One types "/invite
nickname" with an optional channel number.  The receiving user gets a
one-line message indicating the sender and the invitation.  The
receiving user is free to ignore the invitation, of course.

*** 6.3.11: ignore

If one wants to ignore messages sent by some other user or users, it
may be done with /ignore command. One can ignore someone by their
nickname, or by their user@host data. Wildcards may be used. 

*** 6.3.12: users

/users will return a list of the users logged into one's system.  With
an optional hostname identifying a chat server host, the users logged
into that system will be listed.

*** 6.3.13: stats

This command returns counts of various protocol operations of one's
chat server.  It is neither particularly useful nor interesting to
users other than operators.

*** 6.3.14: nick

One can change nicknames by issuing "/nick new-nickname."  All users
on one's channel will be advised of the change.  NOTE: If one enters
chat with a nickname clash (e.g., one's login name is the same as
someone else's, and the other user got there first), the system will
not let one enter until one issues a /nick command with a unique
nickname.

*** 6.3.15: away

Sometimes, one wishes to remain connected to the chat system, but one
must be elsewhere for a while.  One can issue an /away command with
arbitrary text as argument, which will mark oneself as being away.  If
someone sends an away'd user a private message (via /msg or in a
private session set up via /query; see below), the sender will get a
message back from the server indicating the away-ness and the message
which was set.

*** 6.3.16: info

/info returns information regarding the author and copyright of the
chat system.

*** 6.3.17: clear

At times, one wishes that one's screen weren't so cluttered.  /clear
makes it so.

*** 6.3.18: query

This command is used to set up private communications `outside' the
normal channel system.

When one enters "/query nickname," the indicated nickname is set up as
the sole recipient of anything which one types thereafter.  Thus, if
user A executes "/query B" and user B executes "/query A," they have
set up a private communication between themselves.  Significantly, it
remains possible for them to stay on their respective channels, which
need not be the same, and listen to whatever conversation is going on
around them as well, though they cannot respond to that ambient
conversation without leaving the private conversation they have set up.

One leaves this private mode by issuing /query without arguments.

*** 6.3.19: cmdch

The `/' character may not be best for some people to use as their
command character.  It can be changed with "/cmdch <character>."

*** 6.3.20: mode

This command can be used for altering the various modes of a channel
(see the explanation of channel modes above). /mode command can only
be issued by channel operators. 

** 6.4: Operator commands

The chat system administrators on each host have additional
responsibilities and power over the configuration and operation of the
servers.  The commands to do so are delineated below.

*** 6.4.1: oper

Users who have the potential for operator privileges initially invoke
those privileges by "/oper nickname password," where nickname is the
nickname under which operation is intended, and password is the
password known to the chat system for that nickname.

*** 6.4.2: kill

Obnoxious users had best beware the operator who's fast on the /kill
command.  "/kill nickname" blows any given nickname completely out of
the chat system.

Obnoxiousness is not to be tolerated.  But operators should not use
/kill lightly.

*** 6.4.3: quote

Raw access to the underlying server protocol is possible through the
user of the /quote command.  "/quote any text at all" is used to send
direct, unmodified commands to the servers.  This has a wide variety
of uses, such as deliberately killing a local or remote chat daemon,
invoking operator privileges for otherwise-operator-priv-forbidden
users, and related tasks.  It is, again, a very powerful operation,
and not to be used lightly.

* 7: Questions, problems, troubles?

If you have problems, please contact Christopher Davis (ckd@eff.org) or
Helen Rose (hrose@eff.org). Known as "ckd" and "Trillian" on irc,
respectively. You can also ask for help on some of the operator
channels on irc, for example #twilight_zone and #eu-opers. They will
be able to assist you in whatever problems you are having with IRC.


